﻿$(document).on("pageinit", function () {
    $("[data-questiontype='dragdropranking']").each(function () {
        var context = $(this);
        RemoveSelectedOptions(context);

        $("select.softPromptChoice", context).each(function () {
            $(this).closest(".ui-select").addClass("softPromptChoice").hide();
        });

        $("select", context).on("change", function () {
            var nextChoiceLists = $(this).closest(".ui-select").nextAll("div.ui-select");
            var selectedValue = $(this).val();

            $("select", nextChoiceLists).val("").selectmenu("disable").selectmenu("refresh");
            $("select option[value!='']", nextChoiceLists).detach();
            $("select", nextChoiceLists).append($("select:first option[value!='']", context).clone());

            RemoveSelectedOptions(context);

            if (selectedValue) {
                $("select", nextChoiceLists.first()).selectmenu("enable");
            }
        });
    });
});

$(document).ready(function () {
    truncateOptions(); // Initial call

    $(window).resize(function () {
        truncateOptions(); // Refresh options on resize
    });
});

function truncateOptions() {
    var windowWidth = $(window).width();
    var selectWidth = windowWidth * 0.7; // Select width didn't come with real value in this stage

    var charLimit;
    if (windowWidth >= 1660) {
        charLimit = Math.floor(selectWidth / 8);
    } else {
        charLimit = Math.floor(selectWidth / 7.1);
    }

    $("option").each(function () {
        var fullText = $(this).data("fullText");

        if (!fullText) {
            fullText = $(this).html();
            $(this).data("fullText", fullText);
        }

        $(this).text(fullText.length > charLimit ? fullText.substr(0, charLimit) + "..." : fullText);
    });

    $(".select-ui").trigger("change");
}


function RemoveSelectedOptions(context) {
    var hasEmptyEnabled = false;

    $("select", context).each(function () {
        var selectedOption = $(this).val();
        var nextChoiceLists = $(this).closest(".ui-select").nextAll("div.ui-select");
        if (selectedOption) {
            $("select option[value='" + selectedOption + "']", nextChoiceLists).detach();
        }
        else if (!hasEmptyEnabled) {
            hasEmptyEnabled = true;
        }
        else {
            $(this).selectmenu("disable");
        }
    });
}